version 13 // indicates version 
cls // clears backscroll display buffer
clear all // "start from scratch"
set more off // suppresses -more- prompts

/* load data */
cd "C:\Users\benja\Dropbox\BenjaminWork\ResearchProject\data\creation\data-sets and merge\social trust\recode"
use "SocialTrust.dta"

/* recode */

// recode missings //
mvdecode _all, mv(999) 

// sensible variable names //
rename nomem_encr id
rename cp08a019 trust8
rename cp09b019 trust9
rename cp10c019 trust10
rename cp11d019 trust11
rename cp12e019 trust12
rename cp13f019 trust13 
drop cp14g019 // last wave has no observations

/* check for no duplicate entries */
bys id: gen N = _N
assert N == 1
drop N // no duplicate ids

/* this is individual id, but individuals are nested in households, 
   which is ignored here */ 

////////////////////// WIDE /////////////////////////////////
stata2mplus using SocialTrust, replace
/////////////////////////////////////////////////////////////

////////////////////// LONG /////////////////////////////////
reshape long trust, i(id) j(wave) // wide to long
stata2mplus using SocialTrustLong, replace
/////////////////////////////////////////////////////////////

label var trust "Social trust (0=dis-,10=trusting)"

////////////// STATA FILE FOR MERGING ///////////////////////
saveold d09_st, replace
/////////////////////////////////////////////////////////////

